<?php
# PHPFMG_ID:'20110109-3983'
# Date : 20110109 10:48:48
# Generated By Free PHP Formmail Generator : http://phpfmg.sourceforge.net
# -----------------------------------------------------------------------------



define( 'PAYPAL_ID' , '' ); // Put donation ID here to disable the copyright link

define( 'PHPFMG_ID' , '20110109-3983' );
define( 'PHPFMG_TO' , 'sunindustriesgobi@gmail.com,sunenterprisesroofing@gmail.com,info@sunindustries.org' );
define( 'PHPFMG_REDIRECT', '' );

define( 'PHPFMG_ROOT_DIR' , dirname(__FILE__) );
define( 'PHPFMG_SAVE_FILE' , PHPFMG_ROOT_DIR . '/form-data-log.php' ); // save submitted data to this file
define( 'PHPFMG_EMAILS_LOGFILE' , PHPFMG_ROOT_DIR . '/email-traffics-log.php' ); // log email traffics to this file
define( 'PHPFMG_ADMIN_URL' , 'admin.php' );

define( 'PHPFMG_SAVE_ATTACHMENTS' , '' );
define( 'PHPFMG_SAVE_ATTACHMENTS_DIR' , PHPFMG_ROOT_DIR . '/uploaded/' );

// three options : empty - always mail file as attachment, 0 - always mail file as link, N - mail file as link if filesize larger than N Kilobytes
define( 'PHPFMG_FILE2LINK_SIZE' , '' );

define( 'PHPFMG_UPLOAD_CONTROL' , '' );
define( 'PHPFMG_HARMFUL_EXTS' , ".php, .html, .css, .js, .exe, .com, .bat, .vb, .vbs, scr, .inf, .reg, .lnk, .pif, .ade, .adp, .app, .bas, .chm, .cmd, .cpl, .crt, .csh, .fxp, .hlp, .hta, .ins, .isp, .jse, .ksh, .Lnk, .mda, .mdb, .mde, .mdt, .mdw, .mdz, .msc, .msi, .msp, .mst, .ops, .pcd, .prf, .prg, .pst, .scf, .scr, .sct, .shb, .shs, .url, .vbe, .wsc, .wsf, .wsh" );
define( 'PHPFMG_HARMFUL_EXTS_MSG' , 'File is potential harmful. Upload is not allowed.' );
define( 'PHPFMG_ALLOW_EXTS' , ".jpg, .gif, .png, .bmp" );
define( 'PHPFMG_ALLOW_EXTS_MSG' , "Upload is not allowed. Please check your file type." );

define( 'PHPFMG_CC' , '' );
define( 'PHPFMG_BCC', '' );
define( 'PHPFMG_SUBJECT' , "Sun Industries Enquiry form Details" );
define( 'PHPFMG_RETURN_SUBJECT' , "" ); // auto response mail subject
define( 'PHPFMG_CHARSET' , 'UTF-8' );
define( 'PHPFMG_MAIL_TYPE' , 'html' ); // send mail in html format or plain text.
define( 'PHPFMG_ACTION' , 'mailandfile' ); // delivery method
define( 'PHPFMG_TEXT_ALIGN' , 'top' ); // field label text alignment: top, right, left
define( 'PHPFMG_NO_FROM_HEADER' , '' ); // don't make up From: header.
define( 'PHPFMG_SENDMAIL_FROM' , '' ); // force sender's email 
define( 'PHPFMG_SMTP' , '' ); // send email via this SMTP server


define( 'HOST_NAME',getEnv( 'SERVER_NAME' ) );
define( 'PHP_SELF', getEnv( 'SCRIPT_NAME' ) );
define( 'PHPFMG_LNCR', "\x0d\x0a" );

define( 'PHPFMG_ANTI_HOTLINKING' , '' );
define( 'PHPFMG_REFERERS_ALLOW', "" ); // Referers - domains/ips that you will allow forms to reside on.
define( 'PHPFMG_REFERERS_DENIED_MSG', "You are coming from an <b>unauthorized domain.</b>" ); 


phpfmg_init();
# -----------------------------------------------------------------------------









function phpfmg_thankyou(){
    phpfmg_redirect_js();
?>

<!-- [Your confirmation message goes here] -->
	<br>

    <b>Your Enquiry Details has been sent. <BR/>Thank you!</b>
    <br><br>

<?php

} // end of function phpfmg_thankyou()



function phpfmg_auto_response_message(){
    ob_start();
?>

<?php
    $msg = ob_get_contents() ;
    ob_end_clean();
    return trim($msg);
}



function phpfmg_mail_template(){
    ob_start();
?>

<?php
    $msg = ob_get_contents() ;
    ob_end_clean();
    return trim($msg);
}




# --- Array of Form Elements ---
$GLOBALS['form_mail'] = array();
$GLOBALS['form_mail']['field_0'] = array( "name" => "field_0", "text" => "Name",  "type" => "sender's name", "instruction" => "", "required" => "Required" ) ;

$GLOBALS['form_mail']['field_2'] = array( "name" => "field_2", "text" => "Address",  "type" => "textarea", "instruction" => "", "required" => "" ) ;
$GLOBALS['form_mail']['field_3'] = array( "name" => "field_3", "text" => "Email",  "type" => "sender's email", "instruction" => "", "required" => "Required" ) ;
$GLOBALS['form_mail']['field_4'] = array( "name" => "field_4", "text" => "City",  "type" => "select", "instruction" => "", "required" => "Required" ) ;
$GLOBALS['form_mail']['field_5'] = array( "name" => "field_5", "text" => "Phone",  "type" => "text", "instruction" => "", "required" => "" ) ;
$GLOBALS['form_mail']['field_6'] = array( "name" => "field_6", "text" => "Mobile",  "type" => "text", "instruction" => "", "required" => "Required" ) ;
$GLOBALS['form_mail']['field_1'] = array( "name" => "field_1", "text" => "Enquiry For",  "type" => "text", "instruction" => "", "required" => "Required" ) ;
$GLOBALS['form_mail']['field_8'] = array( "name" => "field_8", "text" => "Enquiry Details",  "type" => "textarea", "instruction" => "", "required" => "Required" ) ;

?>
<?php
/**
 * Copyright (C) : http://www.formmail-maker.com
*/

function phpfmg_init(){

  error_reporting( E_ERROR );
  ini_set('magic_quotes_runtime', 0);
  ini_set( 'max_execution_time', 0 );
  ini_set( 'max_input_time', 36000 );
  session_start();
  phpfmg_check_referers();

  if ( get_magic_quotes_gpc() && isset($_POST) ) {
      phpfmg_stripslashes( $_POST );
  };
  
}


function phpfmg_stripslashes(&$var){
    if(!is_array($var)) {
        $var = stripslashes($var);
    } else {
        array_walk($var,'phpfmg_stripslashes');
    };
}


function phpfmg_display_form(){
    @header( 'Content-Type: text/html; charset=' . PHPFMG_CHARSET );
    $phpfmg_send = phpfmg_sendmail( $GLOBALS['form_mail'] ) ;
    $isHideForm  = isset($phpfmg_send['isHideForm']) ? $phpfmg_send['isHideForm'] : false;
    $sErr        = isset($phpfmg_send['error'])      ? $phpfmg_send['error']      : '';

    # FormMail main()
    phpfmg_header();
    if( !$isHideForm ){
        phpfmg_form($sErr);
    }else{
        phpfmg_thankyou();
    };
    phpfmg_footer();
    
    return;
}


function phpfmg_sendmail( &$form_mail ) {
	if( !isset($_POST["formmail_submit"]) ) return ;

	$isHideForm = false ;
    $sErr = checkPass($form_mail);
    
    $err_captcha = phpfmg_check_captcha();
    if( $err_captcha != '' ){
        $sErr['fields'][] = 'phpfmg_captcha';
        $sErr['errors'][] = ERR_CAPTCHA;
    };
    
    if( empty($sErr['fields']) ){
        
        if( defined('PHPFMG_SENDMAIL_FROM') && '' != PHPFMG_SENDMAIL_FROM ){
            ini_set("sendmail_from", PHPFMG_SENDMAIL_FROM); 
        };
        if( defined('PHPFMG_SMTP') && '' != PHPFMG_SMTP ){
            ini_set("SMTP", PHPFMG_SMTP); 
        };
        
		sendFormMail( $form_mail, PHPFMG_SAVE_FILE ) ;
		$isHideForm = true;
		// move the redirect to phpfmg_thankyou() to get around the redirection within an iframe problem
		/*
		$redirect = PHPFMG_REDIRECT;
		if( strlen(trim($redirect)) ):
			header( "Location: $redirect" );
			exit;
		endif;
		*/
    }; 

	return array(
		'isHideForm' => $isHideForm,
		'error'      => $sErr ,		
	); 
}



function    sendFormMail( $form_mail, $sFileName = ""  ) 
{ 
	$to        = filterEmail(PHPFMG_TO) ;
	$cc        = filterEmail(PHPFMG_CC) ;
	$bcc       = filterEmail(PHPFMG_BCC) ;
    
    // simply chop email address to avoid my website being abused
    if( false !== strpos( strtolower($_SERVER['HTTP_HOST']),'formmail-maker.com') ){
        $cc   = substr($cc, 0, 50);
        $bcc = substr($bcc,0, 50);
    };    
    
    
	$subject   = PHPFMG_SUBJECT ; 
	$from      = $to ;
	$fromName  = "";
	$titleOfSender = '';
	$firstName  = "";
	$lastName  = "";
	
    $strip     = get_magic_quotes_gpc() ;
    $content   = '' ; 
    $style     = 'font-family:Verdana, Arial, Helvetica, sans-serif; font-size : 13px; color:#474747;padding:6px;border-bottom:1px solid #cccccc;' ;
    $tr        = array() ; // html table
    $csvValues = array();
    $cols      = array();
    $replace   = array();
    $RecordID  = phpfmg_getRecordID();
    $isWritable = is_writable( dirname(PHPFMG_SAVE_ATTACHMENTS_DIR) );
              
    foreach( $form_mail as $field ){
        $field_type = strtolower($field[ "type" ]);
        if( 'sectionbreak' == $field_type ){
            continue;
        };
        
        $value    = trim( $_POST[ $field[ "name" ] ] ); 
        $value    = $strip ? stripslashes($value) : $value ;
        if( 'attachment' == $field_type ){
            $value = $isWritable ? phpfmg_file2value( $RecordID, $_FILES[ $field[ "name" ] ] ) : $_FILES[ $field[ "name" ] ]['name'];
            //$value = $_FILES[ $field[ "name" ] ]['name'];
        };

        $content    .= $field[ "text" ] . " \t : " . $value .PHPFMG_LNCR;
        $tr[]        = "<tr> <td valign=top style='{$style};width:33%;border-right:1px solid #cccccc;'>" . $field[ "text" ] . "&nbsp;</td> <td valign=top style='{$style};'>" . nl2br($value) . "&nbsp;</td></tr>" ;  
        $csvValues[] = csvfield( $value );
        $cols[]      = csvfield( $field[ "text" ] );
        $replace["%".$field[ "name" ]."%"] = $value;
        
        switch( $field_type ){
            case "sender's email" :
    			$from = filterEmail($value) ;
                break;
            case "sender's name" :
    			$fromName = filterEmail($value) ;
                break;
            case "titleofsender" :
                $titleOfSender = $value ;
                break;
            case "senderfirstname" :
    			$firstName = filterEmail($value) ;
                break;
            case "senderlastname" :
    			$lastName = filterEmail($value) ;
                break;
            default :
                // nothing            		
        }; 
		
    }; // for
    
    $isHtml = 'html' == PHPFMG_MAIL_TYPE ; 
    
    if( $isHtml ) {
        $content = "<table cellspacing=0 cellpadding=0 border=0 >" . PHPFMG_LNCR . join( PHPFMG_LNCR, $tr ) . PHPFMG_LNCR . "</table>" ; 
    };

        
    if( !empty($firstName) && !empty($lastName) ){
        $fromName = $firstName . ' ' . $lastName; 
    };        
    $fromHeader = filterEmail( ('' != $fromName ? "\"$fromName\"" : '' ) . " <{$from}>",array(",", ";")) ; // no multiple emails are allowed.
    
    $_fields = array(
        '%NameOfSender%' => $fromName,
        '%FirstNameOfSender%' => $firstName,
        '%LastNameOfSender%' => $lastName,
        '%EmailOfSender%' => $from,
        '%TitleOfSender%' => $titleOfSender,
        '%DataOfForm%'   => $content,
        '%IP%'   => $_SERVER['REMOTE_ADDR'],
        '%Date%'   => date("Y-m-d"),
        '%Time%'   => date("H:i:s"),
        '%AutoID%' => $RecordID,
    );
    $fields = array_merge( $_fields, $replace );
    
    $esh_mail_template = trim(phpfmg_mail_template()); 
    if( !empty($esh_mail_template) ){
    	$esh_mail_template = phpfmg_adjust_template($esh_mail_template);
        $content = phpfmg_parse_mail_body( $esh_mail_template, $fields );
    };
    $subject = phpfmg_parse_mail_body( $subject, $fields );
    
    if( $isHtml ) {
        $content = phpfmg_getHtmlContent( $content );
    };

    $oldMask = umask(0);
    //$sep = ','; //chr(0x09);
    $sep = chr(0x09);
    $recordCols = phpfmg_data2record( csvfield('RecordID') . $sep . csvfield('Date') . $sep . csvfield('IP') . $sep . join($sep,$cols) ); 
    $record     = phpfmg_data2record( csvfield($RecordID) . $sep . csvfield(date("Y-m-d H:i:s")) . $sep . csvfield($_SERVER['REMOTE_ADDR']) .$sep . join($sep,$csvValues) );

    switch( strtolower(PHPFMG_ACTION) ){
        case 'fileonly' :
               appendToFile( $sFileName, $record, $recordCols );
               break; 
        case 'mailonly' :
              mailAttachments( $to , $subject , $content,  $fromHeader,  $cc , $bcc, PHPFMG_CHARSET ) ;
        	   break;
        case 'mailandfile' :
        default:
              mailAttachments( $to , $subject , $content,  $fromHeader,  $cc , $bcc, PHPFMG_CHARSET ) ;
              appendToFile( $sFileName, $record, $recordCols );
    }; // switch
 
    //mailReport( $content, $sFileName );
	mailAutoResponse( $from, $to, $fields ) ;
    umask($oldMask);
} 





function phpfmg_file2value( $recordID, $file ){
    $tmp  = $file[ "tmp_name" ] ; 
    $name = phpfmg_rename_harmful(trim($file[ "name" ])) ; 
    if( !defined('PHPFMG_FILE2LINK_SIZE') ){
        return $name;
    };
    
    if( is_uploaded_file( $tmp ) ) {
        $size = trim(PHPFMG_FILE2LINK_SIZE) ;
        switch( $size ){
            case '' :
                return $name;
            default:
                $isHtml = 'html' == PHPFMG_MAIL_TYPE;
                $filelink= base64_encode( serialize(array('recordID'=>$recordID, 'filename'=>$name)) );
                $url = phpfmg_admin_url() . "?mod=filman&func=download&filelink=" . urlencode($filelink) ;
                $isLarger = (filesize($tmp)/1024) > $size ;
                $link = $isHtml ? "<a href='{$url}'>$name</a>" : $name . " ( {$url} )";
                return $isLarger ? $link : $name ; // email download link when size is larger defined size, otherwise send as attachment 
        };// switch
    }; // if
    
    return $name;
}



function phpfmg_dir2unix( $dir ){
    return str_replace( array("\\", '//'), '/', $dir );
}



function phpfmg_request_uri(){
	$uri = getEnv('REQUEST_URI'); // apache has this
	if( false !== $uri && strlen($uri) > 0 ){
        return $uri ;
	} else {
	
		$uri = ($uri = getEnv('SCRIPT_NAME')) !== false 
		       ? $uri 
			   : getEnv('PATH_INFO') ;
		$qs = getEnv('QUERY_STRING'); // IIS and Apache has this
	    return $uri . ( empty($qs) ? '' : '?' . $qs );
	
    };
	return "" ;
}



// parse full admin url to view large size uploaded file online
function phpfmg_admin_url(){
    $http_host = "http://{$_SERVER['HTTP_HOST']}";
    switch( true ){
        case (0 === strpos(PHPFMG_ADMIN_URL, 'http://' )) :
            $url = PHPFMG_ADMIN_URL;
            break;
        case ( '/' == substr(PHPFMG_ADMIN_URL,0,1) ) :
            $url = $http_host . PHPFMG_ADMIN_URL ;
            break;
        default:
            $uri = phpfmg_request_uri();
            $pos = strrpos( $uri, '/' );
            $vdir = substr( $uri, 0, $pos );
            $url  = $http_host . $vdir . '/' . PHPFMG_ADMIN_URL ;
    };
    return $url;
}



function phpfmg_ispost(){
	return 'POST' == strtoupper($_SERVER["REQUEST_METHOD"])  || 'POST' == strtoupper(getEnv('REQUEST_METHOD'))  ;
}



// don't allow hotlink form to my website. To avoid people create phishing form. 
function phpfmg_hotlinking_mysite(){
    $yes = false !== strpos( strtolower($_SERVER['HTTP_HOST']),'formmail-maker.com') // accessing form at mysite
           && ( empty($_SERVER['HTTP_REFERER']) || false === strpos( strtolower($_SERVER['HTTP_REFERER']),'formmail-maker.com') ) ; // doesn't have referer of mysite

    if( $yes ){
        die( "<b>Access Denied.</b>
        <br /><br />
        You are visiting a form hotlinkink from <a href='http://www.formmail-maker.com'>formmail-maker.com</a> which is not allowed. 
        Please read the <a href='http://www.formmail-maker.com/web-form-mail-faq.php'>FAQ</a>.   
        " );
    }; 
}



function phpfmg_check_referers(){

    phpfmg_hotlinking_mysite(); // anti phishing
    
    $debugs = array();
    $debugs[] = "Your IP: " . $_SERVER['REMOTE_ADDR'];
    $debugs[] = "Referer link: " . $_SERVER['HTTP_REFERER'];
    $debugs[] = "Host of referer: $referer";
    
    $check = defined('PHPFMG_ANTI_HOTLINKING') && 'Y' == PHPFMG_ANTI_HOTLINKING;
    if( !$check ) {
        $debugs[] = "Referer is empty. No need to check hot linking.";
        //echo "<pre>" . join("\n",$debugs) . "</pre>\n";
        //appendToFile( PHPFMG_EMAILS_LOGFILE, date("Y-m-d H:i:s") . "\t" . $_SERVER['REMOTE_ADDR'] . " \n" .  join("\n",$debugs)  ) ;    
        return true;
    };

    // maybe post from local file
    if( !isset($_SERVER['HTTP_REFERER']) && phpfmg_ispost() ){
        appendToFile( PHPFMG_EMAILS_LOGFILE, date("Y-m-d H:i:s") . "\t" . $_SERVER['REMOTE_ADDR'] . " \n phpfmg_ispost " .  join("\n",$debugs)  ) ;    
        die( PHPFMG_REFERERS_DENIED_MSG );
    }; 

     
    $url     = parse_url($_SERVER['HTTP_REFERER']);
    $referer = str_replace( 'www.', '', strtolower($url['host']) );
    if( empty($referer) ) {
        return true;
    };
    
    $hosts   = explode(',',PHPFMG_REFERERS_ALLOW);
    $http_host =  strtolower($_SERVER['HTTP_HOST']);
    $referer = $http_host ; 
    $hosts[] = str_replace('www.', '', $http_host );

    $debugs[] = "Hosts Allow: " . PHPFMG_REFERERS_ALLOW;
    
    $allow = false ;
    foreach( $hosts as $host ){
        $host = strtolower(trim($host));
        $debugs[] = "check host: $host " ;
        if( false !== strpos($referer, $host) || false !== strpos($referer, 'www.'.$host) ){
            $allow = true;
            $debugs[] = " -> allow (quick exit)"; 
            break;
        }else{
            $debugs[] = " -> deny"; 
        };
    };
    
    //echo "<pre>" . join("\n",$debugs) . "</pre>\n";
    //appendToFile( PHPFMG_EMAILS_LOGFILE, date("Y-m-d H:i:s") . "\t" . $_SERVER['REMOTE_ADDR'] . " \n" .  join("\n",$debugs)  ) ;    
    
    if( !$allow ){
        die( PHPFMG_REFERERS_DENIED_MSG );
    };
}



function phpfmg_getRecordID(){
    if( !isset($GLOBALS['RecordID']) ){
        $GLOBALS['RecordID'] = date("Ymd") . '-'.  substr( md5(uniqid(rand(), true)), 0,4 );
    };
    return $GLOBALS['RecordID'];
}



function phpfmg_data2record( $s, $b=true ){
    $from = array( "\r", "\n"); 
    $to   = array( "\\r", "\\n" );
    return $b ? str_replace( $from, $to, $s ) : str_replace( $to, $from, $s ) ; 
}



function csvfield( $str ){
    $str = str_replace( '"', '""', $str );
    return '"' . trim($str) . '"';
}



function    mailAttachments( $to = "" , $subject = "" , $message = "" , $from = "" , $cc = "" , $bcc = "", $charset = "UTF-8", $type = 'FormMail' ){ 
     
    if( ! strlen( trim( $to ) ) ) return "Missing \"To\" Field." ; 

    $boundary = "====_My_PHP_Form_Generator_" . md5( uniqid( srand( time() ) ) ) . "====";  
    $content_type = 'html' == PHPFMG_MAIL_TYPE ? "text/html" : "text/plain" ;
     
    // setup mail header infomation 
    $headers =  'Y' == PHPFMG_NO_FROM_HEADER ? '' :  "From: $from" .PHPFMG_LNCR;
    if ($cc) $headers .= "CC: $cc".PHPFMG_LNCR;  
    if ($bcc) $headers .= "BCC: $bcc".PHPFMG_LNCR;  
    //$headers .= "Content-type: {$content_type}; charset={$charset}" .PHPFMG_LNCR ; 

    $plainHeaders = $headers ; // for no attachments header
    $plainHeaders .= 'MIME-Version: 1.0' . PHPFMG_LNCR;
    $plainHeaders .= "Content-type: {$content_type}; charset={$charset}" ;
	
    //create mulitipart attachments boundary 
    $sError = "" ; 
    $nFound = 0; 

    if( array_key_exists($GLOBALS['phpfmg_files_content']) && '' != $GLOBALS['phpfmg_files_content'] ){
        
        // use previous encoded content
        $sEncodeBody = $GLOBALS['phpfmg_files_content'] ;
        $nFound = true ;
        
    }else{

        $file2link_size = trim(PHPFMG_FILE2LINK_SIZE) ;
        $isSave = ('' != $file2link_size || defined('PHPFMG_SAVE_ATTACHMENTS') && 'Y' == PHPFMG_SAVE_ATTACHMENTS);
        if( $isSave ){
            if( defined('PHPFMG_SAVE_ATTACHMENTS_DIR') ){
                if( !is_dir(PHPFMG_SAVE_ATTACHMENTS_DIR) ){
                    $ok = @mkdir( PHPFMG_SAVE_ATTACHMENTS_DIR, 0777 );
                    if( !$ok ) $isSave = false;
                };
            };
        };

        $isWritable = is_writable( dirname(PHPFMG_SAVE_ATTACHMENTS_DIR) );          
        // parse attachments content
        foreach( $_FILES as $aFile ){ 
            $sFileName = $aFile[ "tmp_name" ] ; 
            $sFileRealName = phpfmg_rename_harmful($aFile[ "name" ]) ; 
            if( is_uploaded_file( $sFileName ) ): 
                
                $isSkip = '' != $file2link_size && ( (filesize($sFileName)/1024) > $file2link_size );
                // save uploaded file
                if( $isWritable && $isSave ){
                    $tofile = PHPFMG_SAVE_ATTACHMENTS_DIR . phpfmg_getRecordID() . '-' . basename($sFileRealName);
                    if( @copy( $sFileName, $tofile) ) chmod($tofile,0777);
                };

                if( $isSkip )
                    continue; // mail file as link
                 
                if( $fp = @fopen( $sFileName, "rb" ) ) : 
                    $sContent = fread( $fp, filesize( $sFileName ) ); 
                    $sFName = basename( $sFileRealName ) ; 
                    $sMIME = getMIMEType( $sFName ) ; 
                     
                    $bPlainText = ( $sMIME == "text/plain" ) ; 
                    if( $bPlainText ) : 
                        $encoding = "" ; 
                    else: 
                        $encoding = "Content-Transfer-Encoding: base64".PHPFMG_LNCR;  
                        $sContent = chunk_split( base64_encode( $sContent ) );  
                    endif; 
                     
                    $sEncodeBody .=     PHPFMG_LNCR."--$boundary" .PHPFMG_LNCR.  
                                        "Content-Type: $sMIME;" .  PHPFMG_LNCR.
                                        "\tname=\"$sFName\"" . PHPFMG_LNCR. 
                                        $encoding .  
                                        "Content-Disposition: attachment;" . PHPFMG_LNCR.  
                                        "\tfilename=\"$sFName\"" . PHPFMG_LNCR. PHPFMG_LNCR. 
                                        $sContent . PHPFMG_LNCR ; 
                    $nFound ++;                                                 
                else: 
                    $sError .= "<br>Failed to open file $sFileName.\n" ; 
                endif; // if( $fp = fopen( $sFileName, "rb" ) ) : 
                 
            else: 
                $sError .= "<br>File $sFileName doesn't exist.\n" ; 
            endif; //if( file_exists( $sFileName ) ): 
        }; // end foreach 
        $sEncodeBody .= PHPFMG_LNCR.PHPFMG_LNCR."--$boundary--" ; 

    }; // if
    
    $headers .= "MIME-Version: 1.0".PHPFMG_LNCR."Content-type: multipart/mixed;".PHPFMG_LNCR."\tboundary=\"$boundary\"";  
    $txtMsg = PHPFMG_LNCR."This is a multi-part message in MIME format." .PHPFMG_LNCR .  
              PHPFMG_LNCR."--$boundary" .PHPFMG_LNCR . 
              "Content-Type: {$content_type};".PHPFMG_LNCR.
              "\tcharset=\"$charset\"" .PHPFMG_LNCR.PHPFMG_LNCR .  
              $message . PHPFMG_LNCR; 
    
    $body    = $nFound ? $txtMsg . $sEncodeBody : $message ;
    $headers = $nFound ? $headers : $plainHeaders ; 
    $ok      = mail( $to, $subject, $body, $headers  );
    $status = $ok ? "\n[Email sent]" : "\n[Failed to send mail]" ;
    phpfmg_log_mail( $to, $subject, ($ok ? 'Email sent' : 'Failed to send mail') . "\n" . ($nFound ? $headers  . $txtMsg : $headers . $message), '', $type . $status ); // no log for attachments 
    
    return $sError ;         
} 




function mailAutoResponse( $to, $from, $fields = false ){
    if( !formIsEMail($to) ) return ERR_EMAIL ; // one more check for spam robot
	$body = trim(phpfmg_auto_response_message());
	if( empty($body) ){
	   return false ;
	};
	
	$subject = PHPFMG_RETURN_SUBJECT;
	$isHtml = 'html' == PHPFMG_MAIL_TYPE ;
	$body = phpfmg_adjust_template($body);
	$body = phpfmg_parse_mail_body($body,$fields);
    $subject = phpfmg_parse_mail_body( $subject, $fields );
    if( $isHtml ) {
        $body = phpfmg_getHtmlContent( $body );
    };		
    $body = str_replace( "0x0d", '', $body ); 		
    $body = str_replace( "0x0a", PHPFMG_LNCR, $body ); 	
	
	return mailAttachments( $to , $subject , $body,  filterEmail($from),  '' , '', PHPFMG_CHARSET, 'AutoResponseEmail' ) ;
}



function phpfmg_log_mail( $to='', $subject='', $body='', $headers = '', $type='' ){
    $sep = str_repeat('----',20) . "\r\n" ; 
    appendToFile( PHPFMG_EMAILS_LOGFILE, date("Y-m-d H:i:s") . "\t" . $_SERVER['REMOTE_ADDR'] . "\t{$type}\r\n"  . $sep . "To: {$to}\r\nSubject: {$subject}\r\n" . $headers . $body  . "\r\n" . $sep  ) ;
}



function phpfmg_getHtmlContent( $body ){
    $html = "
<html>
    <title>Your Form Mail Content | htttp://phpfmg.sourceforge.net</title>
<style type='text/css'>
    body, td{
        font-family : Verdana, Arial, Helvetica, sans-serif;
        font-size : 13px;
    }
</style>
    <body>
    
"
    . $body . 
"    
    
    </body>
</html>        
";
    return $html ;
}  



function phpfmg_adjust_template( $body ){
	$isHtml = 'html' == PHPFMG_MAIL_TYPE ;
    if( $isHtml ){
        $body = preg_match( "/<[^<>]+>/", $body ) ? $body : nl2br($body); 
    };
    return $body;
}



function phpfmg_parse_mail_body( $body, $fields = false ){
    if( !is_array($fields) )
        return $body ;
    
    $yes = function_exists( 'str_ireplace' );
    foreach( $fields as $name => $value ){
        $body = $yes ? str_ireplace( $name, $value ,$body ) 
                     : str_replace ( $name, $value ,$body );
    }; 
    return trim($body);
}



# filter line breaks to avoid emails injecting
function filterEmail($email, $chars = ''){
    $email = trim(str_replace( array("\r","\n"), '', $email ));
    if( is_array($chars) ) $email = str_replace( $chars, '', $email );
    $email = preg_replace( '/(cc\s*\:|bcc\s*\:)/i', '', $email );
    return $email;
}



function mailReport( $content = "", $file = '' ){
	$content = "
Dear Sir or Madam,

Your online form at " . HOST_NAME . PHP_SELF . " failed to save data to file. Please make sure the web user has permission to write to file \"{$file}\". If you don't know how to fix it, please forward this email to technical support team of your web hosting company or your Administrator.

PHPFMG 
- PHP FormMail Generator
";
    mail(PHPFMG_TO, "Error@" . HOST_NAME . PHP_SELF, $content );
}



function	remove_newline( $str = "" ){
    return str_replace( array("\r\n", "\r", "\n"), array('\r\n', '\r', '\n'), $str );
}



function	checkPass( $form_mail = array() )
{

    $names = array();
    $labels = array();
    
    foreach( $form_mail as $field ){
		$type     = strtolower( $field[ "type" ]  );
		$value    = trim( $_POST[ $field[ "name" ] ] );
		$required = strtolower($field[ "required" ]) ;
		$text     = stripslashes( $field[ "text" ] );
		
		// simple check the field has something keyed in.
		if( !strlen($value) && (  $required == "required" ) && $type != "attachment" ){
		    $names[] = $field[ "name" ];
		    $labels[]  = $text;
			//return ERR_MISSING . $text  ;
			continue;
        };   

		// verify the special case
		if( 
			( strlen($value) || $type == "attachment" ) 
			&&  $required == "required" 
		):
		
			switch( $type ){
				case 	strtolower("Sender's Name") :
						  break;
				case 	strtolower("Generic email"):
				case 	strtolower("Sender's email"):
						   if( ! formIsEMail($value) )	 {
                    		    $names[] = $field[ "name" ];
                    		    $labels[]  = $text . ERR_EMAIL;
                            //return ERR_EMAIL . $text ;
                           };
						   break;
				case	"text" :
							break;
				case 	"textarea" :
							break;
				case	"checkbox" :
				case 	"radio" :
							break;
				case 	"select" :
							break;
				case 	"attachment" :
							$upload_file = $_FILES[ $field["name"] ][ "tmp_name" ] ;
							if( ! is_uploaded_file($upload_file)  ){
                    		    $names[] = $field[ "name" ];
                    		    $labels[]  = $text;
								//return  ERR_SELECT_UPLOAD . $text; 
							};
							break;
				case strtolower("Date(MM-DD-YYYY)"):
							break;
				case strtolower("Date(MM-YYYY)"):
							break;
				case strtolower("CreditCard(MM-YYYY)"):
							if( $value < date("Y-m") ) {
                    		    $names[] = $field[ "name" ];
                    		    $labels[]  = $text;
                                //return ERR_CREDIT_CARD_EXPIRED  . $text;
                            }; 
							break;
				case strtolower("CreditCard#"):
							if( !formIsCreditNumber( $value )  ) {
                    		    $names[] = $field[ "name" ];
                    		    $labels[]  = $text;
                                //return ERR_CREDIT_CARD_NUMBER  . $text ;
                            };
							break;
				case strtolower("Time(HH:MM:SS)"):
							break;
				case strtolower("Time(HH:MM)"):
							break;
				default :
					//return $sErrRequired . $form_mail[ $i ][ "text" ];
			}; // switch
		endif;
	}; // for
	
	return array(
	   'fields' => $names,
       'errors' => $labels,  
    );
}



function formSelected( $var, $val ) 
{ 
    echo ( $var == $val ) ? "selected" : ""; 
} 



function formChecked( $var, $val ) 
{ 
    echo ( $var == $val ) ? "checked" : ""; 
} 



function    formIsEMail( $email ){ 
        return ereg( "^(.+)@(.+)\\.(.+)$", $email ); 
} 



function    selectList( $name, $selectedValue, $start, $end, $prompt = "-Select-", $style = "" ) 
{ 
    $tab = "\t" ; 
    print "<select name=\"$name\" $style>\n" ; 
    print $tab . "<option value=''>$prompt</option>\n" ; 
    $nLen = strlen( "$end" ) ; 
    $prefix_zero = str_repeat( "0", $nLen ); 
    for( $i = $start; $i <= $end ; $i ++ ){ 
        $stri = substr( $prefix_zero . $i, strlen($prefix_zero . $i)-$nLen, $nLen ); 
        $selected = ( $stri == $selectedValue ) ? " selected " : "" ; 
        print $tab . "<option value=\"$stri\" $selected >$stri</option>\n" ; 
    } 
    print "</select>\n\n" ; 
} 



# something like CreditCard.pm in perl CPAN 
function formIsCreditNumber( $number ) { 
     
    $tmp = $number; 
    $number = preg_replace( "/[^0-9]/", "", $tmp ); 

    if ( preg_match(  "/[^\d\s]/", $number ) )  return 0; 
    if ( strlen($number) < 13  && 0+$number ) return 0;  

    for ($i = 0; $i < strlen($number) - 1; $i++) { 
        $weight = substr($number, -1 * ($i + 2), 1) * (2 - ($i % 2)); 
        $sum += (($weight < 10) ? $weight : ($weight - 9)); 
    } 

    if ( substr($number, -1) == (10 - $sum % 10) % 10  )  return $number; 
    return $number; 
} 


/* --------------------------------------------------------------------------------------------------- 
    Parameters: $sFileName 
    Return : 
        1. "" :  no extendsion name, or sFileName is empty 
        2. string: MIME Type name of array aMimeType's definition. 
   ---------------------------------------------------------------------------------------------------*/ 
function    getMIMEType( $sFileName = "" ) { 
    $sFileName = strtolower( trim( $sFileName ) ); 
    if( ! strlen( $sFileName  ) ) return ""; 
     
    $aMimeType = array(  
        "txt" => "text/plain" , 
        "pdf" => "application/pdf" , 
        "zip" => "application/x-compressed" , 
        
        "html" => "text/html" , 
        "htm" => "text/html" , 
        
        "avi" => "video/avi" , 
        "mpg" => "video/mpeg " , 
        "wav" => "audio/wav" , 
        
        "jpg" => "image/jpeg " , 
        "gif" => "image/gif" , 
        "tif" => "image/tiff " , 
        "png" => "image/x-png" , 
        "bmp" => "image/bmp"  
    ); 
    $aFile = split( "\.", basename( $sFileName ) ) ; 
    $nDiminson = count( $aFile ) ; 
    $sExt = $aFile[ $nDiminson - 1 ] ; // get last part: like ".tar.zip", return "zip" 
     
    return ( $nDiminson > 1 ) ? $aMimeType[ $sExt ] : "";  
} 



function    appendToFile( $sFileName = "", $line = "", $dataColumnsLine = '' ){ 
    if( !$sFileName || !$line ) return 0;

    $isExists = file_exists( $sFileName );
    $hFile = @fopen( "$sFileName", "a+w" ); 
    $nBytes = 0; 
    if( $hFile ){ 
        if( !$isExists && false !== strpos(strtolower(basename($sFileName)), '.php') ){
            fputs( $hFile, "<?php exit(); /* For security reason. To avoid public user downloading below data! */?>\r\n");
            if( !empty($dataColumnsLine) ){
                fputs($hFile,$dataColumnsLine."\r\n");
            };
        };
        $nBytes = fputs( $hFile , trim($line)."\r\n" ); 
        fclose( $hFile ); 
    }; 
    return $nBytes ; 
} 

function phpfmg_get_csv_header(){
    $csvValues = array();
    foreach( $GLOBALS['form_mail'] as $field ){
        $csvValues[] = csvfield( $field[ "text" ] );
    };
    return join(chr(0x09),/*","*/$csvValues) ;
}

/*
function phpfmg_field_instruction($name, $show = true ){  
    global $form_mail, $sErr;
    $isError = in_array($name,$sErr['fields']);
    $class = $isError ? 'instruction_error' : 'instruction' ;
    if( $show || $isError ) echo "<div class='{$class}'>". htmlspecialchars_decode($form_mail[ $name ]['instruction']) . "</div>";
}
*/

function phpfmg_rand( $len = 4 ){
    $md5 = md5( uniqid(rand()) );
    return $len > 0 ? substr($md5,0,$len) : $md5 ;
}





function phpfmg_check_captcha(){
    $errmsg = '';
    if( phpfmg_is_reCAPTCHA() ){
        $resp = recaptcha_check_answer (reCAPTCHA_PRIVATE_KEY,
                                        $_SERVER["REMOTE_ADDR"],
                                        $_POST["recaptcha_challenge_field"],
                                        $_POST["recaptcha_response_field"]);
        $errmsg = $resp->is_valid ? '' : $resp->error ;
        
    }else{
        
        if( isset($_SESSION[PHPFMG_ID.'fmgCaptchCode']) && strtoupper($_POST['fmgCaptchCode']) != strtoupper($_SESSION[PHPFMG_ID.'fmgCaptchCode']) ){
            $errmsg = ERR_CAPTCHA ;
        };
        
    };
    
    return $errmsg ;
}


function phpfmg_is_reCAPTCHA(){
    return defined('reCAPTCHA_PUBLIC_KEY') && defined('reCAPTCHA_PRIVATE_KEY') && function_exists ("mcrypt_encrypt") && is_file( PHPFMG_ROOT_DIR.'/recaptchalib.php' ) ;
}

function phpfmg_show_captcha(){
    if( phpfmg_is_reCAPTCHA() ){
        echo recaptcha_get_html(reCAPTCHA_PUBLIC_KEY);
        return ;
    };
    
    $url = PHPFMG_ADMIN_URL . '?mod=captcha&amp;func=get&amp;tid=' ;
?>
    <img id="phpfmg_captcha_image" src="<?php echo $url . time();?>" onClick="this.src='<?php echo $url ;?>'+Math.random();" border=0 style="cursor:pointer;" alt="Click the image to reload. PHP FormMail Generator at http://phpfmg.sourceforge.net">
    <a href="http://phpfmg.sourceforge.net" onClick="document.getElementById('phpfmg_captcha_image').src='<?php echo $url ;?>'+Math.random();return false;" style="color:#474747;" title="Reload PHP FormMail Generator Security Image" >Reload Image</a><br>
    <input type='text' name="fmgCaptchCode" value="" class="fmgCaptchCode" style="width:73px;" >  
<?php
}


function phpfmg_hsc($field, $default){
    echo isset($_POST[ $field ]) 
         ? HtmlSpecialChars( $_POST[ $field ] ) 
         : $default;
}

function phpfmg_dropdown( $name, $options, $extra = '', $isReturn = false ){
    $dropdown = array();
    $list = explode( '|', $options );
    $dropdown[] = "<select name='{$name}' class='text_select' {$extra} >";
    //$dropdown[] = "<option value='' >{$select}</option>";
    if( is_array($list) ){
        foreach( $list as $opt ){
            $o = phpfmg_parse_option( $opt );
            if( isset($_POST['formmail_submit']) ){ 
                $selected = $o['value'] == $_POST[ $name ]  ? 'selected' : '' ;
            }else{
                $selected = $o['default'] ? 'selected' : '' ;
            };
            $dropdown[] = "<option value=\"{$o['value']}\" {$selected}>{$o['text']}</option>";
        };
    };
    $dropdown[] = "</select>\n";
    $s = join("\t\n",$dropdown);

    if( $isReturn )
        return $s;
    else
        echo $s ;
}

function phpfmg_dependent_dropdown( $field_name ){
    $field = phpfmg_dependent_dropdown_get_field( $field_name );
    $dd = new DependantDropdown(); 
    $dd->parseFmgField($field);
    $html = $dd->getHtml();
    echo $html;
}

function phpfmg_dependent_dropdown_dynamic_require( $field_name ){
    $field = phpfmg_dependent_dropdown_get_field( $field_name );
    $dd = new DependantDropdown();
    $dd->parseFmgField($field);
    $dd->dynamicRequired(); 
}

function phpfmg_dependent_dropdown_get_field( $field_name ){
    if( !isset($_SESSION[PHPFMG_ID]) ){
        $_SESSION[PHPFMG_ID] = array();
    };
    if( !isset($_SESSION[PHPFMG_ID]['DD_DATA_' . $field_name]) ){
        $base64 = phpfmg_dependent_dropdown_data();
        $data = @unserialize( base64_decode($base64) );
        $_SESSION[PHPFMG_ID]['DD_DATA_' . $field_name] = $data;
    }else{
        $data = $_SESSION[PHPFMG_ID]['DD_DATA_' . $field_name]; 
    };
    
    if( !is_array($data) ){
        return ;
    };
    
    foreach( $data as $field ){
        if( $field['name'] == $field_name ){
            return $field;
        };
    };
}


# ------------------------------------------------------
class DependantDropdown
{
    var $data = '';
    var $sheet = array();
    var $fields = array();
    var $fieldInfo = array( 'label', 'instruction', 'required', 'prompt' ); // describe field information from the first N rows of data
    var $prefix = 'dd'; // in case there is no name for dropdown, it will name the dropdown like dd_0, dd_1, ... 

    var $fmgField = false;
    var $newliner = "<!--esh_newline-->" ; // replace \r\n with $newliner ;
	var $newtaber = "<!--esh_newtaber-->" ; // replace \t with $newtaber ;
    
    function DependantDropdown(){
    }

    
    function lookupFieldColumn( $field, $column, $lookup, $contentType='text/plain', $charset='utf-8' ){
        $this->parseFmgField( $field );
        $this->nocache_headers( $contentType, $charset );
        return join( "\n", $this->getColumn( $column, $lookup ) );
    }

    function parseFmgField( $field ){
        if( !isset($_SESSION[PHPFMG_ID]) ){
            $_SESSION[PHPFMG_ID] = array();
        };
        $this->fmgField = $field;
        $value = $this->newline_back($field['value']);
        $this->data = explode("\r\n",$value);
        if( !isset($_SESSION[PHPFMG_ID][ "DD_".$field['name'] ]) ){
            $this->parseData($field);
            $_SESSION[PHPFMG_ID][ "DD_".$field['name'] ] = $this->fields;
        }else{
            $this->fields = $_SESSION[PHPFMG_ID][ "DD_".$field['name'] ]; 
        };
        $this->makeupFieldsName();
    }
    
	function	newline_back( $str = "" ){
		return str_replace( array($this->newtaber, $this->newliner),  array("\t","\r\n"), $str );
	}
    
    function nocache_headers($contentType='text/plain', $charset='utf-8'){
        header("Expires: Mon, 01 Jan 1970 00:00:01 GMT");
        header("Cache-Control: max-age=0, no-store, no-cache, must-revalidate");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        header( "Content-Type: {$contentType}; charset={$charset}" );
    }
  
    
    function setData( $s ){
        $this->data = $s ;
    }
    
    function setPrefix( $s ){
        $this->prefix = $s;
    }
    
    function parseData(){
        $tab = chr(0x09);
        $nFieldInfoRows = count( $this->fieldInfo );
        for( $i = 0, $n = count($this->data); $i < $n; $i ++ ){
            $line = str_replace('"', '', $this->data[$i] );
            $cols = explode( $tab, $line );

            if( is_array($cols) && count($cols) > 1 ){
            
                if( $i < $nFieldInfoRows ){
                    $trims = array();
                    foreach( $cols as $col ){
                        $trims[] = trim($col);
                    };
                    $this->fields[ $this->fieldInfo[$i] ] = $trims;
                }
                else
                    $this->fields['data'][] = $cols;
            
            }; // if
            
            //if ( $i > 1000 ) break;
        }; // for
        
    }
    
    // $quickTest : to see whether a column contains data
    function getColumn( $n, $lookup = array(), $quickTest = false ){ 
        $count = count($lookup);
        if( $n > 0 && empty($count) ){
            return array(); // can not get column without search query  
        };
        
        $col        = array();
        $lastValue  = $lookup[ $count - 1 ];
        $flatLookup = join( '|', $lookup );
        
        foreach( $this->fields['data'] as $r ){
        
            if( !isset($r[$n]) )
                continue;

            $value = trim($r[$n]);
            if( $value == '' )
                continue;
                
            //$value = $r[$n];
            if( $n == 0 ){            
                $col[] = $value;
            }else{
                
                //if( trim($r[$n-1]) == $lastValue ){ // quick check to improve performance 
                if( $r[$n-1] == $lastValue ){ // quick check the last value to improve performance
                    $leftCols       = array_slice( $r, 0, $n );
                    $flatLeftValues = join( '|', $leftCols );
                    if( $flatLeftValues == $flatLookup ){ // show value only by lookuping by joining all its parents' values
                        $col[] = $value;
                    };
                }; // if
                
            }; // if $n == 0
            
            if( $quickTest && count($col) > 0 ) break;
              
        }; // foreach
        
        return array_unique($col);
    }
    
    function getColumnOptions( $n, $lookup = array(), $default = '' ){
        $opts = array();
        foreach( $this->getColumn($n, $lookup) as $v ){
            $selected = $default == $v ? 'selected' : '' ; 
            $opts[] = "<option {$selected} value=\"" . htmlspecialchars($v) . "\">{$v}</option>";
        };
        return join("\n",$opts);
    }
    
    function getHtml(){
        $html = array();
        
        $field_name = $this->fmgField['name'];
        $this->prefix = $field_name;
        $count = count($this->fields['label']);

        // prepare for getting column options after form submitted
        $lookup = array();
        $isPost = isset($_POST[ $this->fields['name'][0] ]);
        if( $isPost ){
            for( $i = 0; $i < $count; $i++  ){
                $label        = $this->fields['label'][$i];
                if( empty($label) )
                    continue;

                $lookup[] = $_POST[ $this->fields['name'][$i] ];  
            };
        };
                
        for( $i = 0; $i < $count; $i++  ){
            $label        = $this->fields['label'][$i];
            if( empty($label) )
                continue;
                
            $name         = $this->fields['name'][$i];
            $instruction  = $this->fields['instruction'][$i];
            $prompt       = $this->fields['prompt'][$i];
            $required     = $this->fields['required'][$i];
            $promptOption = empty($prompt) ? "" : "<option value=''>{$prompt}</option>";
            if( $isPost )
                $options = $this->getColumnOptions( $i, array_slice($lookup,0,$i), $_POST[$name] );
            else
                $options = $this->getColumnOptions( $i, array(), '' );
                                 
            $select = "<select id='{$name}' class='text_select' name='{$name}' onchange=\"dd_change({$i}, {$count}, '{$this->prefix}');\">{$promptOption}" . $options . "</select>";
            $sRequired = "<label class='form_required' >" . (strtolower($required) == 'required'? '*' : '&nbsp;') . "</label>" ;
$li = "
<li class='field_block' id='{$name}_div'>
    <div class='col_label'>
	   <label class='form_field'>{$label}</label>{$sRequired} 
    </div>
	<div class='col_field'>
    	{$select}
    	<div id='{$name}_tip' class='instruction'>{$instruction}</div>
	</div>
</li>
";
            $html[] = $li;
        };

        echo join("\n\n",$html);
        
    }


    function dynamicRequired(){
        if( !isset($_POST) ){
            return ;
        };
        
        $field_name = $this->fmgField['name'];
        $this->prefix = $field_name;
        $count = count($this->fields['label']);

        $lookup = array();
        $isPost = isset($_POST[ $this->fields['name'][0] ]);
        if( $isPost ){
            for( $i = 0; $i < $count; $i++  ){
                $label        = $this->fields['label'][$i];
                if( empty($label) )
                    continue;

                $lookup[] = $_POST[ $this->fields['name'][$i] ];  
            };
        };
                
        for( $i = 0; $i < $count; $i++  ){
            $label        = $this->fields['label'][$i];
            if( empty($label) )
                continue;
                
            $name = $this->fields['name'][$i];
            $required = $this->fields['required'][$i];
            if( strtolower($required) == 'required' ){
                $rows = $this->getColumn( $i, array_slice($lookup,0,$i), true );
                if( empty($rows) ) {
                    $GLOBALS['form_mail'][ $name ]['required'] = '' ; //
                };
            }else{
                $GLOBALS['form_mail'][ $name ]['required'] = '' ;
            };  
        };

    }
    
    
    function getFormMailArrayCode(){
        $code = array();
        for( $i = 0, $n = count($this->fields['label']); $i < $n; $i++  ){
            $label        = $this->fields['label'][$i];
            if( empty($label) )
                continue;
            $name         = $this->fields['name'][$i];
            $instruction  = $this->fields['instruction'][$i];
            $prompt       = $this->fields['prompt'][$i];
            $required     = $this->fields['required'][$i];
			$code[] = "\$GLOBALS['form_mail']['{$name}'] = array( \"name\" => \"$name\", \"text\" => \"" . addslashes( $label ) . "\",  \"type\" => \"select\", \"instruction\" => \"$instruction\", \"required\" => \"$required\" ) ;" ;
        };
        return join("\n",$code);
    }    

    function makeupFieldsName($default='field_99'){
        $field_name = isset($this->fmgField['name']) ? $this->fmgField['name'] : $default;
        $this->prefix = $field_name;
        for( $i = 0, $n = count($this->fields['label']); $i < $n; $i++  ){
            $this->fields['name'][$i] = $this->prefix . '_' . $i;
        };
    }
      
}



function phpfmg_parse_option( $opt ){
    $opt = $opt;
    $a = array(
        'text' => $opt,
        'value' => $opt,
        'default' => false,
    );
    $pos = strrpos( $opt, '=' );
    if( false !== $pos ){
        $a['text'] = substr($opt,0,$pos);
        $part = substr($opt,$pos+1);
        $nv = strrpos( $part, ',' );
        if( false !== $nv ){
            $a['value'] = substr($part,0,$nv);
            $a['default'] = 'default' == strtolower(substr($part,$nv+1));  
        }else{
            $a['value'] = $part;
        };
    };
    $a['text'] = trim($a['text']);
    $a['value'] = trim($a['value']);
    return $a ;
}



function phpfmg_choice( $type, $name, $options, $isReturn = false ){
    $radios = array();
    $list = explode( '|', $options );
    if( is_array($list) ){
        $i = 0 ;
        foreach( $list as $opt ){
            //$value = HtmlSpecialChars( $opt );
            $o = phpfmg_parse_option( $opt );
            $id = "{$name}_{$i}";
            $newname = 'checkbox' == $type ? "Checkbox" . substr("00".($i+1), strlen("00".($i+1))-2,2) . "_" . $name : $name;
            if( isset($_POST['formmail_submit']) ){ 
                $checked = $o['value'] == $_POST[ $newname ]  ? 'checked' : '' ;
            }else{
                $checked = $o['default'] ? 'checked' : '' ;
            };
            //$radios[] = "<input type='{$type}' name='{$newname}' id='{$id}'  value=\"{$o['value']}\"  {$checked} class='form_{$type}' ><label class='form_{$type}_text' onclick=\"fmgHandler.choice_clicked('{$id}');\" onmouseover=\"this.className='form_{$type}_text form_choice_over';\" onmouseout=\"this.className='form_{$type}_text form_choice_out';\">{$o['text']}</label><br />";
            $labelLeft = ''; //0 == $i ? '' : "<div class='form_field'>&nbsp;</div><div class='choice'>&nbsp;</div>" ; // spacer for text algin left             
            $radios[] = "{$labelLeft}<input type='{$type}' name='{$newname}' id='{$id}'  value=\"{$o['value']}\"  {$checked} class='form_{$type}' ><label class='form_choice_text' for='{$id}'>{$o['text']}</label><br>";
            $i ++ ;
        };
    };
    $s = join("\t\n",$radios);
    //$s = "<div class='choices'>$s</div>";

    if( $isReturn )
        return $s;
    else
        echo $s ;
}



function phpfmg_radios( $name, $options, $isReturn = false ){
    return phpfmg_choice( 'radio', $name, $options, $isReturn );
}



function phpfmg_checkboxes( $name, $options, $isReturn = false ){
    return phpfmg_choice( 'checkbox', $name, $options, $isReturn );
}


function phpfmg_rename_harmful( $name ){
    //if( defined('PHPFMG_BLOCK_HARMFUL') && 'Y' == PHPFMG_BLOCK_HARMFUL ){
		$ext = strrchr(strtolower($name), '.');
		if( $ext !== false ){
            $n = strpos( strtolower(PHPFMG_HARMFUL_EXTS), $ext );
            if( $n !== false ){
                return $name . '.bak' ;
            };
        };
    //};
    
    return $name;
}


function phpfmg_redirect_js(){
    if( defined('PHPFMG_REDIRECT') && '' != PHPFMG_REDIRECT ){
        echo "<script type='text/javascript'>
            function phpfmg_redirect(){
                var redirect = '" . addslashes(PHPFMG_REDIRECT) . "';
                try{
                    if( parent ) parent.location.href = redirect;
                }catch(e){
                    location.href = redirect;
                };
            }
            
            phpfmg_redirect();
        </script>"; 
    };
}


if (!function_exists("htmlspecialchars_decode")) {
   function htmlspecialchars_decode($string, $quote_style = ENT_COMPAT) {
       return strtr($string, array_flip(get_html_translation_table(HTML_SPECIALCHARS, $quote_style)));
   }
}



function phpfmg_text_align(){
    $align = strtolower(defined('PHPFMG_TEXT_ALIGN') ? PHPFMG_TEXT_ALIGN : 'top');
    switch( $align ){
        case 'left' :
        case 'right' :

            $labelWidth = '158px';
            if( false !== strpos( strtolower($_SERVER['HTTP_USER_AGENT']), 'msie') ){
            # ----------- for IE -------
            $css = "
ol.phpfmg_form{
    width: 468px;
}

div.col_field, div.col_label{
    display:inline;
    float:left;
}

div.col_label{
    width:{$labelWidth};
    text-align: {$align};
}
";

            }else{
            
            # ----------- for Firefox -------
            $css = "
div.col_label{
    float:left;
    width:{$labelWidth};
    text-align: {$align};
}

div.col_field{ margin-left:{$labelWidth}; }
";
            }; // if
            break;

        case 'top' :
        default:
            $css = "";
            break;
    }; // switch
    
    echo $css;
}


function phpfmg_header(){
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
   
    
<?php
phpfmg_form_css();
?>

<title>PHP FormMail Generator - A tool to create ready-to-use web forms in a flash</title></head>

<body>

<div class='form_description'>

</div>
<?php
}



function phpfmg_footer(){
?>

<div class='form_footer'>

</div>
<?php
    if( defined('PAYPAL_ID') && '' == PAYPAL_ID ){ 
?>


	<br><br>
	
	

<?php
};// if

?>
 </body>
</html>
<?php
}



function phpfmg_javascript( $sErr = '' ){
?>
<script type="text/javascript">
 function dd_change( n, max, prefix ){
    if( n >= max-1 )
        return; // the last dropdown, no need to query
    
    //var prefix = 'dd_' ;
    // reset all other dropdown options
    var next = n+1; 
    for( var i = next; i < max; i ++ ){
        var dd = document.getElementById(prefix +'_' + i );
        if( dd && dd.length >= 1 ) dd.length = 1 ; // keep the first one '- select -'
    };


    // request drop down data from server
    var me = this;
    var http;
    if(navigator.appName == "Microsoft Internet Explorer"){
        me.http = new ActiveXObject("Microsoft.XMLHTTP");
    }else{
        me.http = new XMLHttpRequest();
    };
    
    
    // build query string
    var lookup = [];
    for( var i = 0; i < next; i ++ ){
        lookup.push( "lookup[" + i + "]=" + document.getElementById(prefix +'_' +  i ).value )
    };
    lookup = lookup.join('&');
    
    var url = '<?php echo PHPFMG_ADMIN_URL . '?mod=dd&func=lookup&' ; ?>n='+next+ '&field_name=' + prefix + '&' + lookup;
    me.http.open('get', url);
    me.http.onreadystatechange = function(){
    
        if( me.http.readyState == 4 ){
            // rebuild the next dropdown options
            var eNext = document.getElementById(prefix +'_' + next );
            if( !eNext )
                return;
            
            var data = me.http.responseText;    
            var opts = String(data).split("\n");
            for( var j = 0, J = opts.length; j < J; j ++ ){
                eNext.options[ eNext.length ] = new Option( opts[j], opts[j], false, false );                
            }; // for
        }; //if
        
    }; 
    me.http.send(null);

 }
 
    
function PHPFMG( formID ){
    var frmID = formID;
    var exts = {
        'upload_control' : '<?php echo PHPFMG_UPLOAD_CONTROL; ?>',
        'harmful_exts'  : '<?php echo PHPFMG_HARMFUL_EXTS; ?>',
        'harmful_errmsg': "<?php echo addslashes(PHPFMG_HARMFUL_EXTS_MSG); ?>",
        'allow_exts'  : '<?php echo PHPFMG_ALLOW_EXTS; ?>',
        'allow_errmsg': "<?php echo addslashes(PHPFMG_ALLOW_EXTS_MSG); ?>"
    };

    function $( id ){
        return document.getElementById(id);
    }

    function get_form( id ){
        var frm = 'object' == typeof($(id)) ? $(id) : eval( 'document.' + id ) ;
        return frm ? frm : document.forms[0];
    } 
    
    function file_ext( f ){
        var n = f.lastIndexOf(".");
        return -1 == n ? '' : f.substr( n ).toLowerCase();
    }
    
    function addLabelEvents(){
        var labels = document.body.getElementsByTagName('LABEL');
        for( var i = 0, N = labels.length; i < N; i ++ ){
            var e = labels[i];
            if( -1 != String(e.className).indexOf('form_choice_text') ){
                var oid = e.getAttribute('oid'); 
                if( !oid ) continue;

                e.onmouseout = function(){ this.className = 'form_choice_text'; };
                e.onmouseover = function(){ this.className = 'form_choice_text form_choice_over'; };
                e.onclick = function(){
                    try{
                        var oid = this.getAttribute('oid'); 
                        var O = document.getElementById(oid);
                        O.checked = !O.checked;
                    }
                    catch(E){};
                };
            }; // if
        }; // for
    } 


    function addFieldBlockEvents(){
        var divs = document.body.getElementsByTagName('DIV');
        for( var i = 0, N = divs.length; i < N; i ++ ){
            var e = divs[i];
            if( -1 != String(e.className).indexOf('field_block') ){
                e.onmouseout = function(){  if( String(this.className).indexOf('form_error_highlight') == -1 ) this.className = 'field_block'; };
                e.onmouseover = function(){ if( String(this.className).indexOf('form_error_highlight') == -1 ) this.className = 'field_block field_block_over'; };
            }; // if
        }; // for
    } 

    function removeHighliht(){
        var divs = document.body.getElementsByTagName('DIV');
        for( var i = 0, N = divs.length; i < N; i ++ ){
            var e = divs[i];
            var cn = String(e.className);
            if( -1 != cn.indexOf('form_error_highlight') ){
                e.className = cn.replace('form_error_highlight','');
            }; // if
        }; // for
    } 
    
    function showProcessing(){
        try{
            var E = $('phpfmg_processing');
            if( !E ) return ;
            if( -1 != navigator.userAgent.toLowerCase().indexOf('msie') ){
                E.style.backgroundColor='#2960AF';
                $('phpfmg_processing_gif').style.display = 'none';
                setInterval( 'fmgHandler.dots()', 380 );
            };
            E.style.display = '' ;
        }catch(e){};
        
    }
    
    
    this.highlight_fields = function( fields ){
        var A = fields.split(',');
        for( var i = 0, N = A.length; i < N; i ++ ){
            var E = $( A[i] + '_div' );
            if( E ){
                E.className += ' form_error_highlight'; 
            };
            var T = $( A[i] + '_tip' );
            if( T ){
                T.className += ' instruction_error'; 
            };
        };
        if( A.length > 0 ) $('err_required').style.display='';
    }
    
    this.choice_clicked = function( id ){
        $(id).checked = !$(id).checked ;
    }
    
    
    this.init = function(){
        //addLabelEvents();
        addFieldBlockEvents();
    }

    this.harmful = function(e){
        if( 'deny' != exts['upload_control'] ){
            return; 
        };
        
        var ext = file_ext(e.value);
        if( -1 != exts['harmful_exts'].toLowerCase().indexOf(ext) ){
            alert( exts['harmful_errmsg'] );
            e.value = '';
        };
    } 
        
    this.is_allow = function(e){
        if( 'allow' != exts['upload_control'] ){
            return; 
        };
        
        var ext = file_ext(e.value);
        if( -1 == exts['allow_exts'].toLowerCase().indexOf(ext) ){
            alert( exts['allow_errmsg'] );
            e.value = '';
        };
    } 

    this.check_upload = function(e){
        if( '' == exts['upload_control'] )
            return ;
        else
            return ( 'deny' == exts['upload_control'] ) 
                   ? this.harmful(e) 
                   : this.is_allow(e);
    }

    this.dots = function(){
        $('phpfmg_processing_dots').innerHTML += '.';
		if( $('phpfmg_processing_dots').innerHTML.length >= 38 ) {
			$('phpfmg_processing_dots').innerHTML = '.';
		};
    }
    
    this.onsubmit = function(){
        showProcessing();
        return true;
    }
    


    var Form = null;
    var err_fields=null;
}
var fmgHandler = new PHPFMG();
fmgHandler.init();

<?php
if( isset($sErr['fields']) ){
    echo"
    location.href='#error'; 
    fmgHandler.highlight_fields('" . join(',',$sErr['fields']) ."');
    ";
};
?>

</script>
<?php
} // end of function
?>
<?php
function phpfmg_formini(){
    return "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";
}

function phpfmg_dependent_dropdown_data(){
    return "YTowOnt9";
}
?>