(function ($) {

	$(document).ready(function () {

		// transitions demo

		$('.tabs-x.fade').jTabs({
			marker: true
		});

		$('.tabs-x.scale.back').jTabs({
			marker: true,
			fx: { transform: 'scale', timing: 'ease-in-out-back', duration: 0.6 }
		});

		$('.tabs-x.scale-x.back').jTabs({
			marker: true,
			fx: { transform: 'scaleX', timing: 'ease-in-out-back', duration: 0.6 }
		});

		$('.tabs-x.scale-y.back').jTabs({
			marker: true,
			fx: { transform: 'scaleY', timing: 'ease-in-out-back', duration: 0.6 }
		});

		$('.tabs-x.nofx').jTabs({
			marker: true,
			fx: false
		});

		// horizontal tabs

		$('.tabs-x.general').jTabs({
			nesting: true,
			anchors: true,
			mobinav: true
		});

		$('.tabs-x.marker').jTabs({
			marker: true
		});

		$('.tabs-x').jTabs();

		// vertical tabs

		$('.tabs-y.break').jTabs({
			vertical: true,
			breakpoint: 600
		});

		$('.tabs-y.marker').jTabs({
			marker: true,
			vertical: true
		});

		$('.tabs-y').jTabs({
			vertical: true
		});

		// toggle html direction using keyboard

		$(document).bind('keydown', function (e) {
			var key = e.keyCode || e.which, shift = e.shiftKey;

			if (shift && key === 82) {
				$('html').set('dir', $.isRTL() ? 'ltr' : 'rtl');
			}
		});

		// outline links only for keyboard navigation

		$(document).bind('mousedown mouseup', function (event) {
			var link = $(event.target || event.srcElement);

			if (link.parent().name('a')) {
				link = link.parent();
			}
			if (link.name('a')) {
				link.style('outline', event.type === 'mousedown' ? 'none' : '')
				.context.blur();
			}
		});

	});
}(Jaegers));
